/**
 * The Clock class implements basic functionality of a simulated time.
 *
 * The main puropse of the Clock class is to demnostrate class
 * definition and difference between static and instance members.
 *
 *
 * @author Roman Szturc
 */
public class Clock {
   /**
    * Number of units of simulated time. Since it is declared as static, 
    * it is shared among all instances of the Clock class.
    */
   protected static long universalTime;

   /**
    * Time adjustment.
    */
   protected long timeAdjustment;
   
   /**
    * Advances current time by one unit.
    */
   public static void advance() {
      universalTime++;
   }
   
   /**
    * Returns number of time units of current univerzal simulated 
    * time.
    *
    * @return the univerzal time.
    */
   public static long getUniversalTime() {
      return universalTime;
   }
   
   /**
    * Sets time of the receiver. The newly set time is local for
    * the receiver.
    *
    * @param the new time
    */
   public void setTime(long time) {
      timeAdjustment = time - getUniversalTime();
   }
   
   /**
    * Returns current time of the receiver.
    *
    * @return the current time.
    */
   public long getTime() {
      return getUniversalTime() + timeAdjustment;
   }
}
