/**
 * The LocalClock class implements basic functionality of a simulated time
 * with time zone offset.
 *
 * The main puropse of the Clock class is to demnostrate class
 * definition and difference between static and instance members.
 *
 *
 * @author Roman Szturc
 */
public class LocalClock extends Clock {
   /**
    * West time zone offset boundary.
    */
   public static long MIN_OFFSET = -12;

   /**
    * East time zone offset boundary.
    */
   public static long MAX_OFFSET = 12;
   
   /**
    * Time zone offset.
    */
   protected long timeZoneOffset;
   
   /**
    * Sets time zone offset.
    *
    * @param the offset to set
    */
   public void setTimeZoneOffset(long offset) {
      if (offset < MIN_OFFSET || offset > MAX_OFFSET)
         throw new IllegalArgumentException("illegal offset " +
            offset + ", it must be in range " +
            MIN_OFFSET + ".." + MAX_OFFSET);
            
      timeZoneOffset = offset;
   }

   /**
    * Returns time zone offset of the receiver.
    *
    * @return the time zone offset.
    */
   public long getTimeZoneOffset() {
      return timeZoneOffset;
   }
   
   /**
    * Sets time of the receiver. The newly set time is local for
    * the receiver.
    *
    * @param the new time
    */
   public void setTime(long time) {
      super.setTime(time - timeZoneOffset);
   }
   
   /**
    * Returns current time of the receiver, including time zone
    * offset.
    *
    * @return the current time.
    */
   public long getTime() {
      return super.getTime() + timeZoneOffset;
   }
}
