public class Main {
   public static void main(String[] arguments) {
      LocalClock clock = new LocalClock();
      
      try {
         clock.setTimeZoneOffset(2);
         System.out.println("time zone offset set to " + 
            clock.getTimeZoneOffset());
            
         clock.setTimeZoneOffset(22);
         System.out.println("time zone offset set to " + 
            clock.getTimeZoneOffset());
      }
      catch (IllegalArgumentException e) {
         // Simple error message.
         System.err.println("error: " + e.getMessage());
         
         // Verbose exception report, including stack trace.
         e.printStackTrace();
      }

      try {
         setTimeZoneOffset(clock, 2);
         System.out.println("time zone offset set to " + 
            clock.getTimeZoneOffset());

         setTimeZoneOffset(clock, 22);
         System.out.println("time zone offset set to " + 
            clock.getTimeZoneOffset());
      }
      catch (IllegalArgumentException e) {
         // Simple error message.
         System.err.println("error: " + e.getMessage());
         
         // Verbose exception report, including stack trace.
         e.printStackTrace();
      }
   }
   
   private static void setTimeZoneOffset(LocalClock clock, long offset) {
      try {
         clock.setTimeZoneOffset(offset);
      }
      catch (IllegalArgumentException e) {
         // Just record a problem.
         System.err.println("an attempt to set incorrect time zone " +
            "detected");
         // Propagate the exception to original caller.
         throw e;
      }
   }
   
   private void timingExcepions() {
      StopWatchOnly stop = new StopWatchOnly();
      
      try {
         // Manipulate with stopwatch.
         stop.getResultTime();
      }
      catch (TimingInProgressException e) {
         e.printStackTrace();
      }
      catch (TimingNotStartedException e) {
         e.printStackTrace();
      }
      catch (TimingUnavailableException e) {
         e.printStackTrace();
      }

      
      try {
         // Mainipulate with stopwatch.
         stop.stop();
      }
      catch (TimingException e) {
         if (e instanceof TimingInProgressException)
            e.printStackTrace();
         else if (e instanceof TimingNotStartedException)
            e.printStackTrace();
         else if (e instanceof TimingUnavailableException)
            e.printStackTrace();
      }
      
   }
}
