/**
 * The StopWatch interface defines interface of a stop watch.
 */
public interface StopWatch {
   /**
    * Starts measuring of a time interval.
    */
   public void start() throws TimingException;
   
   /**
    * Stops measuring started by the start method.
    */
   public void stop() throws TimingException;
   
   /**
    * Indicates whether the measuring is in progress.
    */
   public boolean isStarted();
   
   /**
    * Returns number of time units elapsed between invocation
    * of start and stop methods, respectively.
    */
   public long getResultTime() throws TimingException;
}
