/**
 * The StopWatchOnly class demonstrates a possible implementation
 * of StopWatch interface.
 */
public class StopWatchOnly implements StopWatch {
   /**
    * Flag indicating whether the stop watch has already been
    * turned on.
    */
   protected boolean isStarted = false;

   /**
    * Time when measuring of time was started.
    */
   protected long startTime = -1;

   /**
    * The when measuring of time was stopped.
    */
   protected long stopTime;

   /**
    * Starts measuring of a time interval.
    */
   public void start() throws TimingInProgressException {
      if (isStarted)
         throw new TimingInProgressException("timing " +
            "has already been started");
      
      startTime = Clock.getUniversalTime();
      isStarted = true;
   }

   /**
    * Stops measurement started by the start method.
    */
   public void stop() throws TimingNotStartedException {
      if (!isStarted)
         throw new TimingNotStartedException("stopwatch " +
            "hasn't been started yet");
      
      stopTime = Clock.getUniversalTime();
      isStarted = false;
   }

   /**
    * Indicates whether the measuring is in progress.
    */
   public boolean isStarted() {
      return isStarted;
   }
   
   /**
    * Returns number of time units elapsed between invocation
    * of start and stop methods, respectively.
    */
   public long getResultTime() throws TimingUnavailableException {
      if (startTime == -1)
         throw new TimingUnavailableException("stopwatch " +
            "hasn't been started yet");

      return (isStarted() ? Clock.getUniversalTime() : stopTime) - 
         startTime;
   }
}
