import random


def survey1(size, preferences):
    parties = len(preferences)
    count = [0] * parties
    for i in range(size):
        r = random.randint(1, 100)
        for p in range(parties):
            if r <= sum(preferences[0:p + 1]):
                count[p] += 1
                break

    for p in range(parties):
        print("Party {}: {:.2f}".format(p + 1, 100.0 * count[p] / size))


# trochu lepší řešení, nepočítáme součet vždy od začátku:
def survey2(size, preferences):
    parties = len(preferences)
    count = [0] * parties

    for i in range(size):
        r = random.randint(1, 100)
        threshold = 0
        for p in range(parties):
            threshold += preferences[p]
            if r <= threshold:
                count[p] += 1
                break

    for p in range(parties):
        print("Party {}: {:.2f}".format(p + 1, 100.0 * count[p] / size))


survey2(100, [25, 15, 10, 5, 5, 2])
