def print_matrix(matrix):
    for row in matrix:
        print(" ".join(map(str, row)))


def null_matrix(m, n):
    return [[0 for col in range(n)] for row in range(m)]


def matrix_mult(matL, matR):
    rows = len(matL)
    cols = len(matR[0])
    common = len(matR)
    result = null_matrix(rows, cols)
    for i in range(rows):
        for j in range(cols):
            for k in range(common):
                result[i][j] += matL[i][k] * matR[k][j]
    return result


mat = [[1, 2, 3],
       [4, 5, 6],
       [7, 8, 9]]


print(mat[1][2])

print_matrix(mat)

a = [[1, 2, 3],
     [4, 5, 6]]

b = [[0, 1],
     [5, 6],
     [7, 8]]

print()
print_matrix(matrix_mult(a, b))
