def push(stack, element):
    stack.append(element)


def pop(stack):
    return stack.pop()


def top(stack):
    return stack[-1]


def empty(stack):
    return stack.empty()


def eval_rpn(line):
    stack = []
    for token in line.split():
        if token == '*':
            b = pop(stack)
            a = pop(stack)
            push(stack, a * b)
        elif token == '+':
            b = pop(stack)
            a = pop(stack)
            push(stack, a + b)
        else:
            push(stack, int(token))
    return top(stack)


print(eval_rpn("7 4 7 + * 8 +"))
