def is_word_char(char):
    return char not in '!"#$%&\'()*+,-./:;<=>?@[\\]^_`{|}~'


def word_freq(text):
    text = "".join(filter(is_word_char, text))
    text = text.lower()
    word_list = text.split()
    freq = {}
    for word in word_list:
        freq[word] = freq.get(word, 0) + 1
    return freq


laf = """I must not fear.
Fear is the mind killer.
Fear is the little death that brings total obliteration.
I will face my fear.
I will permit it to pass over me and through me.
And when it has gone past I will turn the inner eye to see its path.
Where the fear has gone there will be nothing. Only I will remain."""


def output_word_freq1(text):
    freq = word_freq(text)
    my_list = [(freq[word], word) for word in freq]
    my_list.sort(reverse=True)
    print("Word frequencies, sorted from the most frequent:")
    for count, word in my_list:
        print(count, word)


def output_word_freq2(text):
    freq = sorted(word_freq(text).items(),
                  key=lambda x: (x[1], x[0]),
                  reverse=True)
    print("Word frequencies, sorted from the most frequent:")
    for word, count in freq:
        print(count, word)


output_word_freq2(laf)
