// CSV handling - basic concept

#include <iostream>
#include <fstream>


using namespace std;

struct Actor {
  string name, surname;
  string born;
  string address, eye, hair;
};

bool readActor(ifstream &fromStream, Actor &a) {
    getline(fromStream, a.name, ',');
    getline(fromStream, a.surname, ',');
    getline(fromStream, a.born, ',');
    getline(fromStream, a.address, ',');
    getline(fromStream, a.eye, ',');
    getline(fromStream, a.hair);
    // fromStream >> name >> surname >> born >> address >> eye >> hair;
 return true;
}

bool writeActor(ostream &toStream, Actor a) {
    toStream << a.name << ", " << a.surname  << ", "
             <<  a.born  << ", " << a.address  << ", " <<  a.eye  << ", " << a.hair << endl;
 return true;
}

bool writeActorToCSV(ofstream &toStream, Actor a) {
    toStream << a.name << ", " << a.surname  << ", "
             <<  a.born  << ", " << a.address  << ", " <<  a.eye  << ", " << a.hair << endl;
 return true;
}

int main()
{
    string name = "actors.csv";

    ifstream iF(name.c_str());
    if (iF == NULL) {
      cout << "CSV file open error" << endl;
      return -1;
    }

    Actor actor;
    while (!iF.eof()) {
        readActor(iF, actor);
        writeActor(cout, actor);
    }
    iF.close();

    Actor newA;
     newA.name = "Daniel";
     newA.surname =  "Radcliffe";
     newA.born = "Unknown XX; 1989";
     newA.address = "Fulham; Londýn; Anglie; Velká Británie";
     newA.eye = "???";
     newA.hair = "brown";

    ofstream oF;
    oF.open(name.c_str(), ios::app);
    if (oF == NULL) {
      cout << "CSV file open error" << endl;
      return -1;
    }

     writeActorToCSV(oF, newA);
     oF.close();

    return 0;
}
