import pygame, sys, time           #import jednotlivých knihoven

pygame.init()                       #incializace knihovny pygame
pygame.display.set_caption("Hanojské věže")  #nastavení názvu herního okna
screen = pygame.display.set_mode((640, 480))  #inicializace herního okna, které bude mít rozlišení 640x480 bodů
clock = pygame.time.Clock()

game_done = False               #globální proměnná, ve které je uložen stav hry true=hra ukončena
framerate = 60                  #obnovovací frekvence herního okna

# globální proměné použité ve hře
steps = 0       #počet odehraných kroků
n_disks = 3     #výchozí počet disků ve hře
disks = []      #pole, kde jsou uloženy pozice jednotlivých disků
towers_midx = [120, 320, 520]   #souřadnice os jednotlivých věží
pointing_at = 0                 #ukazatel na aktuální věž
floating = False
floater = 0

# konstanty jednotlivých složek RGB barev
white = (255, 255, 255)
black = (0, 0, 0)
red = (255, 0, 0)
gold = (239, 229, 51)
blue = (78, 162, 196)
grey = (170, 170, 170)
green = (77, 206, 145)


# funkce, která slouží k zobrazení vlastního textu na příslušných souřadnicích, velikosti, fontu a barvě)
def blit_text(screen, text, midtop, aa=True, font=None, font_name=None, size=None, color=(255, 0, 0)):
    if font is None:  # font option is provided to save memory if font is
        font = pygame.font.SysFont(font_name, size)  # already loaded and needs to be reused many times
    font_surface = font.render(text, aa, color)
    font_rect = font_surface.get_rect()
    font_rect.midtop = midtop
    screen.blit(font_surface, font_rect)

#funkce, která je spuštěna před začátkem hry, zde si hráč nastavuje obtížnost hry
def menu_screen():
    global screen, n_disks, game_done
    menu_done = False
    while not menu_done:  # every screen/scene/level has its own loop
        screen.fill(white)
        blit_text(screen, 'Hanojské věže', (323, 122), size=90, color=grey)
        blit_text(screen, 'Hanojské věže', (320, 120), size=90, color=gold)
        blit_text(screen, 'Pomocí šipek zvol počet disků:', (320, 220), size=30, color=black)
        blit_text(screen, str(n_disks), (320, 260), size=40, color=blue)
        blit_text(screen, 'Pro start zmačkni ENTER', (320, 320), size=30, color=black)
        for event in pygame.event.get():                #získáme všechny události (stisk klávesy, myši...)
            if event.type == pygame.KEYDOWN:
                if event.key == pygame.K_q:
                    menu_done = True
                    game_done = True
                if event.key == pygame.K_RETURN:
                    menu_done = True
                if event.key in [pygame.K_RIGHT, pygame.K_UP]:   #stisk šipky nahoru
                    n_disks += 1
                    if n_disks > 6:
                        n_disks = 6
                if event.key in [pygame.K_LEFT, pygame.K_DOWN]:   #stisk šipky dolů
                    n_disks -= 1
                    if n_disks < 1:
                        n_disks = 1
            if event.type == pygame.QUIT:
                menu_done = True
                game_done = True
        pygame.display.flip()                       #akualizace herní obrazovky


#funkce, volána po ukončení hry, slouží k zobrazení výsledku a ukončení hry
def game_over():  # game over screen
    global screen, steps
    screen.fill(white)
    min_steps = 2 ** n_disks - 1
    blit_text(screen, 'Vyhrál jsi!', (320, 200), size=72, color=gold)
    blit_text(screen, 'Počet tvých kroků: ' + str(steps), (320, 360), size=30, color=black)
    blit_text(screen, 'Minimální počet kroků: ' + str(min_steps), (320, 390),  size=30, color=red)
    if min_steps == steps:
        blit_text(screen, 'Výborně, dokázal jsi to na minimální počet tahů!', (320, 300), size=26, color=green)
    pygame.display.flip()
    time.sleep(10)  # čekání 10 sekund
    pygame.quit()  # uvolnění pygame
    sys.exit()  # zavření halvního okna hry

#funkce, která vykreslí tři věže
def draw_towers():
    global screen
    for xpos in range(40, 460 + 1, 200):
        pygame.draw.rect(screen, green, pygame.Rect(xpos, 400, 160, 20))    #nakreslí zelený obdélník pro základnu věže
        pygame.draw.rect(screen, grey, pygame.Rect(xpos + 75, 200, 10, 200)) #nakreslí šedý sloupek věže
    blit_text(screen, 'Start', (towers_midx[0], 403), font_name='mono', size=14, color=black) #pojmenování výchozí věže
    blit_text(screen, 'Cíl', (towers_midx[2], 403), font_name='mono', size=14, color=black)   #pojmenování cílové věže

#funkce, která vytvoří počáteční umístění dísků na první věži
def make_disks():
    global n_disks, disks
    disks = []
    height = 20
    ypos = 397 - height
    width = n_disks * 23
    for i in range(n_disks):
        disk = {}
        disk['rect'] = pygame.Rect(0, 0, width, height)
        disk['rect'].midtop = (120, ypos)
        disk['val'] = n_disks - i
        disk['tower'] = 0
        disks.append(disk)
        ypos -= height + 3
        width -= 23

#funkce, která vykreslí jednotlivé disky na jednotlivé věže
def draw_disks():
    global screen, disks
    for disk in disks:
        pygame.draw.rect(screen, blue, disk['rect'])
    return

#funkce, která vykreslí ukazatel (červený trojúhelník) k vybrané věži
def draw_ptr():
    ptr_points = [(towers_midx[pointing_at] - 7, 440), (towers_midx[pointing_at] + 7, 440),
                  (towers_midx[pointing_at], 433)]
    pygame.draw.polygon(screen, red, ptr_points)
    return


#funkce, která zjistí, zda jsou přesunuty všechny disky na cílový disk
def check_won():
    global disks
    over = True
    for disk in disks:
        if disk['tower'] != 2:
            over = False
    if over:
        time.sleep(0.2)
        game_over()

#funkce, která resetuje všechny proměnné a spustí hlavní menu
def reset():
    global steps, pointing_at, floating, floater
    steps = 0
    pointing_at = 0
    floating = False
    floater = 0
    menu_screen()
    make_disks()


menu_screen()           #zde se volá funkce, která vyvolá hlavním menu
make_disks()            #zde se volá funkce, která poskládá výchozí uložení disků (na první věži) do pole disk


# hlavní herní smyčka (opakuje se tak dlouho, dokud je v globální proměnné game_done hodnota false)
while not game_done:
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            game_done = True
        if event.type == pygame.KEYDOWN:
            if event.key == pygame.K_ESCAPE:
                reset()
            if event.key == pygame.K_q:
                game_done = True
            if event.key == pygame.K_RIGHT:
                pointing_at = (pointing_at + 1) % 3
                if floating:
                    disks[floater]['rect'].midtop = (towers_midx[pointing_at], 100)
                    disks[floater]['tower'] = pointing_at
            if event.key == pygame.K_LEFT:
                pointing_at = (pointing_at - 1) % 3
                if floating:
                    disks[floater]['rect'].midtop = (towers_midx[pointing_at], 100)
                    disks[floater]['tower'] = pointing_at
            if event.key == pygame.K_UP and not floating:
                for disk in disks[::-1]:
                    if disk['tower'] == pointing_at:
                        floating = True
                        floater = disks.index(disk)
                        disk['rect'].midtop = (towers_midx[pointing_at], 100)
                        break
            if event.key == pygame.K_DOWN and floating:
                for disk in disks[::-1]:
                    if disk['tower'] == pointing_at and disks.index(disk) != floater:
                        if disk['val'] > disks[floater]['val']:
                            floating = False
                            disks[floater]['rect'].midtop = (towers_midx[pointing_at], disk['rect'].top - 23)
                            steps += 1
                        break
                else:
                    floating = False
                    disks[floater]['rect'].midtop = (towers_midx[pointing_at], 400 - 23)
                    steps += 1
    screen.fill(white)
    draw_towers()
    draw_disks()
    draw_ptr()
    blit_text(screen, 'Počet kroků: ' + str(steps), (320, 20), size=30, color=black)
    pygame.display.flip()
    if not floating: check_won()
    clock.tick(framerate)