

#import knihoven potřebných pro funkci programu

import feedparser
import requests
import os
import re

# knihovna pro GUI

from tkinter import *
from tkinter import ttk

#  Třída RSSFeedParser, která nám získá data z feedu a předává nám je pro další práci v programu
class RSSFeedParser:
    feedUrl = ""
    feedName = ""
    articles = []

    def __init__(self, name, url):  # konstruktor třídy RSSFeedParser
        self.feedName = name  # Název feedu - bude použit jako název složky
        self.feedUrl = url  # URL feedu - tahají se z něj data
        self.crawlArticles()  # stáhnutí dat z RSS feedu

    def crawlArticles(self):
        self.articles = feedparser.parse(self.feedUrl).entries  # získání dat z feedu

    def getArticlesCount(self):
        return len(self.articles)  # zjištění počtu záznamů

    def getArticle(self, index):
        return self.articles[index]  # Získání jednoho záznamu z již stažených záznamů

    def getArticles(self):  # získání všech stažených záznamů 
        return self.articles

    def renameToFile(self, s):  # Funkce, která nám upraví název tak, aby byl použitelný pro vytvoření souboru.
        s = str(s).strip().replace(' ', '_')
        return re.sub(r'(?u)[^-\w.]', '', s)




window = Tk()
window.geometry("480x240")
ttk.Label(window, text="Zadejte název RSS feedu:").pack(pady=5) # label pro textové pole
feedName = ttk.Entry(window) # textové pole pro vstup uživatele
feedName.pack(pady=5)
ttk.Label(window, text="Zadejte url adresu RSS feedu").pack(pady=5) # label pro textové pole
feedUrl = ttk.Entry(window) # textové pole pro vstup uživatele
feedUrl.pack(pady=5)

def getFeed(): # funkce getFeed použitá na tlačítku se stažením feedu
    rssFeed = RSSFeedParser(feedName.get(), feedUrl.get()) # získání vstupu od uživatele

    articlesCount = rssFeed.getArticlesCount() # zjištění počtu článků

    if articlesCount > 0: # pokud existuje nějaký článek
        print('Nalezeno ', articlesCount, ' clanku\n') # vypíšeme do konzole počet článků

        articles = rssFeed.getArticles() # získáme články

        if os.path.exists(os.path.join(os.getcwd(), rssFeed.feedName)) == False: # jestli neexistuje složka s názvem feedu
            os.mkdir(os.path.join(os.getcwd(), rssFeed.feedName)) # vytvoříme ji


        for item in articles: # a pro každý článek vytvoříme soubor s odkazem na tento článek
            path = os.path.join(os.getcwd(), rssFeed.feedName, rssFeed.renameToFile(item.title) + ".url")
            target = item.link
            shortcut = open(path, 'w')
            shortcut.write('[InternetShortcut]\n')
            shortcut.write('URL=%s' % target)
            shortcut.close()

    else: # pokud zde žádné články nejsou, napíšeme do konzole "feed je prázdný"
        print('Feed je prázdný.')



ttk.Button(window, text="Stáhnout RSS feed", command=getFeed).pack(pady=5) # tlačítko
ttk.Button(window, text="Zavřít program", command=window.destroy).pack(pady=5) # tlačítko


window.mainloop()





