import http.client
import urllib.parse
import json
import folium
import time
import googlemaps
import pandas as pd

gmaps = googlemaps.Client(key='zdevasapikod')

def geodekodovani(adresa):
    geocode_result = gmaps.geocode(adresa)
    print(geocode_result)
    kraj = "NIC"
    #hledani kraje v CR
    for x in geocode_result[0]['address_components']: #prochazeni jednotlivych casti adresy
        for type in x['types']:
            if (type == 'administrative_area_level_1'): #pokud naleznu cast adresy s krajem
                kraj = x['long_name'] #ulozim do promenne kraj
                break
    location = geocode_result[0]['geometry']['location'] #do promenne location souradnice
    return location['lng'], location['lat'], kraj #vratim hodnoty v nasledujicim poradi


def vsechnyadresydogeokodu():
    with open("./zusScraper/zus.json", encoding='utf-8') as jsonFile: #otevreni souboru zus.json
        jsonObject = json.load(jsonFile)
        jsonFile.close()
    seznamzus = [] #vytvoreni prazdneho pole
    for zus in jsonObject:
        adresa = zus['adresa_sidla_skoly']
        longt, latt, kraj = geodekodovani(adresa) #predani adresy do metody geokodovani
        #do jednotlivych promennych ulozim vysledky z metody
        print(zus['nazev_skoly'])
        zus['longt'] = longt
        zus['latt'] = latt
        zus['kraj'] = kraj
        seznamzus.append(zus) #pridani zus do pole
    with open('zusadresa.json', 'w', encoding='utf-8') as outfile: #ukladani do souboru zusadresa.json
        json.dump(seznamzus, outfile, indent=4, ensure_ascii=False)


def pridatbodydomapy():
    for zus in jsonObject:
        folium.Marker(
            [zus['latt'], zus['longt']], popup=f"<i>{zus['nazev_skoly']}</i>"
        ).add_to(mapa)

def heatmapa():
    pocetzusnakraj = { #seznam kraju s poctem zus
        'Hlavní město Praha': 0,
        'Středočeský kraj': 0,
        'Jihočeský kraj': 0,
        'Plzeňský kraj': 0,
        'Karlovarský kraj': 0,
        'Ústecký kraj': 0,
        'Liberecký kraj': 0,
        'Královéhradecký kraj': 0,
        'Pardubický kraj': 0,
        'Kraj Vysočina': 0,
        'Jihomoravský kraj': 0,
        'Olomoucký kraj': 0,
        'Moravskoslezský kraj': 0,
        'Zlínský kraj': 0
    }
    for zus in jsonObject: #pro kazdou zus - zvysim pocet v kraji, kde se nachazi
        if (zus['kraj'] != 'NIC'):
            pocetzusnakraj[zus['kraj']] += 1

    data = pd.DataFrame(list(pocetzusnakraj.items()), #pridani zahlavi do tabulky
                      columns=['kraj','pocet'])

    with open("./SPH_KRAJ.json", encoding='utf-8') as jsonFile:
        jsonKraje = json.load(jsonFile)
        jsonFile.close()

    folium.Choropleth(
        geo_data=jsonKraje, #pouziji nacteny soubor SPH_KRAJ.json
        data=data, #tabulka s pocty v jednotlivych krajich
        columns=['kraj', 'pocet'], #sloupecky z tabulky
        key_on="feature.properties.NAZEV_NUTS", #klic podle ktereho se mapuji data na tabulku
        legend_name="Počet škol v kraji",
    ).add_to(mapa) #pridani do mapy

if __name__ == '__main__':
    #vsechnyadresydogeokodu() #staci spustit 1x
    with open("zusadresa.json", encoding='utf-8') as jsonFile: #otevre soubor zusadresa.json
        jsonObject = json.load(jsonFile)
        jsonFile.close()

    mapa = folium.Map(location=[49.7437572, 15.3386383],zoom_start=8) #nastavi stred zobrazeni mapy
    #pridatbodydomapy()
    heatmapa()
    mapa.save("index.html")










    #folium.LayerControl().add_to(mapa)

