import folium
import pandas as pd

state_geo1 = (r"SPH_KRAJ1.json") #prideli jmeno souboru s geografickymi hranicemi kraje
state_cars1 = (r"data.xlsx") #prideli jmeno souboru s daty
state_data1 = pd.read_excel(state_cars1) #nacte soubor z excelu

state_geo2 = (r"SPH_OKRES.json") #prideli jmeno souboru s geografickymi hranicemi okresu
state_cars2 = (r"okresy.xlsx") #prideli jmeno souboru s daty
state_data2 = pd.read_excel(state_cars2) #nacte soubor z excelu

m = folium.Map(location=[49.8171606, 15.4766247], zoom_start=8) #nastaveni vychoziho zobrazeni mapy

bins = list(state_data1["Auta"].quantile([0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 0.95, 1]))
bins2 = list(state_data2["Auta"].quantile([0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 0.95, 1]))
#Upraveni stupnice

folium.Choropleth(
    geo_data=state_geo1,
    name="Kraje",
    data=state_data1,
    columns=["ID", "Auta"],
    key_on="properties.ID",
    fill_color="Paired",
    fill_opacity=0.7,
    line_opacity=0.3,
    legend_name="Nově přihlášená osobní vozidla podle krajů v roce 2021",
    bins=bins,
    reset=True,
).add_to(m)
#nastaveni co a jak se ma zobrazovat v barevne mape

folium.Choropleth(
    geo_data=state_geo2,
    name="Okresy",
    data=state_data2,
    columns=["ID", "Auta"],
    key_on="properties.ID",
    fill_color="Paired",
    fill_opacity=0.7,
    line_opacity=0.3,
    legend_name="Nově přihlášená osobní vozidla podle okresů v roce 2021",
    bins=bins2,
   reset=True,
).add_to(m)
#nastaveni co a jak se ma zobrazovat v barevne mape

style_function = lambda x: {'fillColor': '#ffffff',
                            'color':'#000000',
                            'fillOpacity': 0.1,
                            'weight': 0.1}
highlight_function = lambda x: {'fillColor': '#000000',
                                'color':'#000000',
                                'fillOpacity': 0.50,
                                'weight': 0.1}
NIL = folium.features.GeoJson(
    state_geo1,
    style_function=style_function,
    control=False,
    highlight_function=highlight_function,
    tooltip=folium.features.GeoJsonTooltip(
        fields=['NAZEV_NUTS'],
        aliases=['Kraj: '],
        style=("background-color: white; color: #333333; font-family: arial; font-size: 12px; padding: 10px;")
    )
)
m.add_child(NIL)
m.keep_in_front(NIL)
folium.LayerControl().add_to(m)
#nastaveni co a jak se ma zobrazovat v prekryvne vrstve

m.save("CZ_cars_2021.html") #vygeneruje soubor s prednastavenym nazvem