import scrapy


class ZusScraper(scrapy.Spider):
    name = "zus"

    def start_requests(self):
        url = 'https://www.izus.cz/kontakt/seznam_zakladnich_umeleckych_skol_v_cr/'
        yield scrapy.Request(url=url, callback=self.parse) #stazeni dat z adresy a zavolani metody parse

    def parse(self, response):
        for zus in response.css('tr'): #pro kazdy radek v tabulce
            yield {
                'nazev_skoly': str(zus.css('.zkraceny_nazev::text').get()).replace(u'\xa0', ''),
                'adresa_sidla_skoly': str(zus.css('.adresa_sidla_skoly > a::text').get()).replace(u'\xa0', ''),
            }
