import matplotlib.pyplot as plt
import os
import pandas as pd
#from urllib.request import urlretrieve

# Seznam souborů (viz níže)
zdroje = [
    # Covid data
    "https://onemocneni-aktualne.mzcr.cz/api/v2/covid-19/incidence-7-14-cr.csv",
]

for zdroj in zdroje:
    # Pouze poslední část cesty adresy datového zdroje je jeho jméno
    jmeno = zdroj.rsplit("/")[-1]
    
    if not os.path.exists(jmeno):        
        print(f"Soubor {jmeno} ještě není stažen, jdeme na to...")
        urlretrieve(url=zdroj, filename=jmeno)
        print(f"Soubor {jmeno} úspěšně stažen.")
    else:
        print(f"Soubor {jmeno} už byl stažen, použijeme místní kopii.")
print("Všechny soubory jsou staženy.")

covid_data = pd.read_csv("incidence-7-14-cr.csv")

x = covid_data["datum"]
y = covid_data["incidence_7"]

plt.plot(x, y, label="Covid data CZE")

# popis os
plt.xlabel("Datum")
plt.ylabel("Incidence za posledních 7 dní")

# hodnoty osy x
plt.xticks([0, 31, 61, 92, 122, 153, 184, 214, 245, 275, 306, 337, 365, 
           396, 426, 457, 487, 518, 549, 579, 610, 640, 671], rotation=90)
 
# legenda dole vpravo
plt.legend(loc="upper left")

# zobrazení grafu
plt.show()