#include <iostream>
#include <fstream>
#include <cstdlib>

using namespace std;

void error_msg(string description = "Error appears, the program is terminated.") {
 cout << endl << description << endl;
 exit(1);
}

bool check(int elem, int size, int arry[]) {
 bool contained = false;
 for (int i = 0; i < size; i++) {
        if (elem == arry[i]) {
            contained = true;
            break;
        }
 }
 return contained;
}

int main()
{
 int sizeA;
 cout << "Enter the elements number: ";
 cin >> sizeA;

 if ((sizeA < 0) || cin.fail()) {
    error_msg("Wrong number of set's elements.");
 }
 int *setA = new int[sizeA];
 int element;

 for (int i = 0; i < sizeA; i++) {
    cin >> element;
    if (check(element, i, setA)) {
        error_msg("An set's element cannot repeat.");
    }
    setA[i] = element;
 }

 bool first = true;
 cout << "{";
 for (int i = 0; i < sizeA; i++) {
    if (!first)
        cout << ", ";
    else
        first = false;
    cout << setA[i];
 }
 cout << "}";

 cout << "output file name: ";
 string filename;
 cin >> filename;

 string header =
  "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">"
  "<META http-equiv=Content-Type content=\"text/html; charset=windows-1250\">"
  "<HTML>"
  "<head> <title>Set</title>"
  "</head>"
  "<body>";
 string footer = "</body></html>";

 ofstream output_HTML(filename.c_str());

 if (output_HTML.fail()) {
    error_msg("Output opening fails.");
 }
 output_HTML << header;

 first = true;
 output_HTML << "{";
 for (int i = 0; i < sizeA; i++) {
    if (!first)
        output_HTML << ", ";
    else
        first = false;
    output_HTML << setA[i];
 }
 output_HTML << "}";
 output_HTML << footer;

 output_HTML.close();

    return 0;
}
