#include <iostream>
#include <fstream>
#include <algorithm>
#include <vector>
#include <string>
#include <cstdlib>
using namespace std;

/**
 * @brief Hlavni soubor programu
 * @file main.cpp
 * @author Ivana Wzientkova
 * @mainpage WZI0004 - Filmoteka
 */

int *vypsaneFilmy = (int*)malloc(sizeof(int));

/**
 * @brief Funkce pro ziskani poctu radku
 * @param soubor    Vstupni soubor, ze ktereho se vypocita pocet radku
 * @return Funkce navraci pocet radku v souboru
 */
int pocetRadku(ifstream &soubor){
    int pocetRadku = 0;
    string poradi;
    while (getline(soubor, poradi)){
        pocetRadku++;
    }
    soubor.clear(); //REWIND
    soubor.seekg(0, ios::beg);
    return pocetRadku;
}

/** @struct Filmy
 *  @brief Struktura obsahujici vsechny filmy
 *  @param Filmy.ID            Specificke ID urcene pro identifikaci filmu
 *  @param Filmy.jmeno         Jmeno filmu
 *  @param Filmy.rok           Rok natoceni filmu
 *  @param Filmy.zanr          Zanr filmu
 *  @param Filmy.puvod         Puvod filmu
 *  @param Filmy.delka         Delka filmu v minutach
 *  @param Filmy.ID_Hercu      ID hercu, kteri ve filmu hrali
 */
typedef struct{
    int ID;
    string jmeno;
    int rok;
    string zanr;
    string puvod;
    int delka;
    string ID_Hercu;
} Filmy;

/** @struct Herci
 *  @brief Struktura obsahujici vsechny herce
 *  @param Herci.ID                  Specificke ID urcene pro identifikaci herce
 *  @param Herci.jmeno               Krestni jmeno herce
 *  @param Herci.prijmeni            Prijmeni herce
 *  @param Herci.datum_narozeni      Datum narozeni herce
 *  @param Herci.misto_narozeni      Misto narozeni herce
 */

typedef struct{
    int ID;
    string jmeno;
    string prijmeni;
    string datum_Narozeni;
    string misto_Narozeni;
} Herci;

void nabizeneAkce(Filmy filmy[], int pocetFilmu, Herci herci[], int pocetHercu);

/**
 * @brief Funkce pro naplneni struktury hercu
 * @param souborHercu    Vstupni soubor, ze ktereho se ctou herci
 * @param herci          pole hercu vytvorenych ze struktury Herci
 */

void naplnStrukturuHercu(ifstream &souborHercu, Herci herci[]){
    string radek;
    int poradi=0;
    while (getline(souborHercu, radek)){
        string ID = "";
        int pozice = 0;
        for(unsigned int i=0;i<radek.length();i++)
        {
           if(radek[i]==';')
           {
               pozice++;
               continue;
           }
           switch(pozice)
           {
                case 0: {ID += radek[i]; break;}
                case 1: {herci[poradi].jmeno += radek[i]; break;}
                case 2: {herci[poradi].prijmeni += radek[i]; break;}
                case 3: {herci[poradi].datum_Narozeni += radek[i]; break;}
                case 4: {herci[poradi].misto_Narozeni += radek[i]; break;}
           }
        }
        herci[poradi].ID = atoi(ID.c_str());
        poradi++;
    }
}

/**
 * @brief Funkce pro naplneni struktury filmu
 * @param souborFilmu    Vstupni soubor, ze ktereho se ctou filmy
 * @param filmy          pole filmu vytvorenych ze struktury Filmy
 */

void naplnStrukturuFilmu(ifstream &souborFilmu, Filmy filmy[]){
    string radek;
    int poradi=0;
    while (getline(souborFilmu, radek)){
        string ID = "";
        string rok = "";
        string delka ="";
        int pozice = 0;
        for(unsigned int i=0;i<radek.length();i++)
        {
           if(radek[i]==';')
           {
               pozice++;
               continue;
           }
           switch(pozice)
           {
                case 0: {ID += radek[i]; break;}
                case 1: {filmy[poradi].jmeno += radek[i]; break;}
                case 2: {rok += radek[i]; break;}
                case 3: {filmy[poradi].zanr += radek[i]; break;}
                case 4: {filmy[poradi].puvod += radek[i]; break;}
                case 5: {delka += radek[i]; break;}
                case 6: {filmy[poradi].ID_Hercu += radek[i]; break;}
           }
        }
        filmy[poradi].ID = atoi(ID.c_str());
        filmy[poradi].rok = atoi(rok.c_str());
        filmy[poradi].delka = atoi(delka.c_str());
        poradi++;
    }
}

/**
 * @brief Funkce Pro vypsani vedlejsich akci
 */

void VypisVedlejsiAkce()
{
    cout << endl;
    cout << "1. Ukoncit program" << endl;
    cout << "2. Vypsat do HTML" << endl;
    cout << "3. Navrat do hlavniho menu" << endl;
}

/**
 * @brief Funkce pro vypsani do HTML souboru
 * @param filmy      pole filmu vytvorenych ze struktury Filmy
 * @param pocet      velikost pole vypsaneFilmy
 */

void vypsatDoHTML(Filmy filmy[], int pocet){

    cout << endl;
    string nazevSouboru = "";
    cout << "Zadejte nazev soboru(bez pripony)" << endl;
    cin >> nazevSouboru;
    cout << endl;
    ofstream out(("..\\vystupnidata\\"+ nazevSouboru+ ".html").c_str());
    out << "<html>"<<endl;
    out << "<head>"<<endl;
    out << "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">"<<endl;
    out << "<title>"<< nazevSouboru<< "</title>"<<endl;
    out << "</head>"<<endl;
    out << "<body>"<<endl;
    out << "<table width=\"550\">"<<endl;
    out << "<tr><th width=\"10\">ID</th><th width=\"210\">Jmeno</th><th width=\"50\">Rok</th><th width=\"80\">Zanr</th><th width=\"50\">Puvod</th><th width=\"50\">Delka</th><th width=\"100\">ID Hercu</th></tr>"<<endl;
    for(int i=0; i<pocet; i++)
    {
        out << "<tr><td>" << filmy[vypsaneFilmy[i]].ID  << "</td><td>"<< filmy[vypsaneFilmy[i]].jmeno << "</td><td>" << filmy[vypsaneFilmy[i]].rok << "</td><td>"<< filmy[vypsaneFilmy[i]].zanr << "</td><td>"<< filmy[vypsaneFilmy[i]].puvod <<"</td><td>"<< filmy[vypsaneFilmy[i]].delka <<"</td><td>"<< filmy[vypsaneFilmy[i]].ID_Hercu << "</td></tr>" << endl;
    }
    out << "</table>"<<endl;
    out <<"</body>"<< endl;
    out <<"</html>"<< endl;
}

/**
 * @brief Funkce pro vypsani vsech filmu ve filmotece
 * @param filmy           pole filmu vytvorenych ze struktury Filmy
 * @param pocetFilmu      pocet filmu ve filmotece
 * @param herci           pole hercu vytvorenych ze struktury Herci
 * @param pocetHercu      pocet hercu v hercich
 */

void vypisFilmy(Filmy filmy[],int pocetFilmu, Herci herci[], int pocetHercu)
{
    cout << endl;
    vypsaneFilmy = (int*)malloc(sizeof(int));
    for(int i = 0; i < pocetFilmu; i++)
    {
        vypsaneFilmy[i] = i;
        cout<< filmy[i].ID<< " ";
        cout<< filmy[i].jmeno<< " ";
        cout<< filmy[i].rok<< " ";
        cout<< filmy[i].zanr<< " ";
        cout<< filmy[i].puvod<< " ";
        cout<< filmy[i].delka<< " ";
        cout<< filmy[i].ID_Hercu<< endl;
    }

    int volba = 0;
    VypisVedlejsiAkce();
    cin >> volba;
    if(volba ==1)
    {
        exit(0);
    }
    else if(volba == 2)
    {
        vypsatDoHTML(filmy, pocetFilmu);
        cout << "Uspesne ulozeno" << endl;
        nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
    }
    else if(volba ==3)
    {
        nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
    }
    else
    {
        cout << "Vase volba byla spatna" << endl;
        nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
    }

}

/**
 * @brief Funkce pro vypsani filmu podle zanru
 * @param filmy           pole filmu vytvorenych ze struktury Filmy
 * @param pocetFilmu      pocet filmu ve filmotece
 * @param herci           pole hercu vytvorenych ze struktury Herci
 * @param pocetHercu      pocet hercu v hercich
 */

void vypisPodleZanru(Filmy filmy[], int pocetFilmu, Herci herci[], int pocetHercu)
{
    cout << endl;
    string vybZanr;
    int pocitadlo = 0;
    cout << "Zadejte zanr: ";
    cin >> vybZanr;
    cout << endl;
    vypsaneFilmy = (int*)malloc(sizeof(int));
    for(int i = 0; i < pocetFilmu;i++)
    {
        if(filmy[i].zanr == vybZanr)
        {
            vypsaneFilmy[pocitadlo] = i;
            cout<< filmy[i].ID<< " ";
            cout<< filmy[i].jmeno<< " ";
            cout<< filmy[i].rok<< " ";
            cout<< filmy[i].zanr<< " ";
            cout<< filmy[i].puvod<< " ";
            cout<< filmy[i].delka<< " ";
            cout<< filmy[i].ID_Hercu<< endl;
            pocitadlo++;
        }

    }

    if(pocitadlo==0)
    {
        cout << "Vami zadany zanr je bud spatny nebo neexistuje film s timto zanrem" << cout;
        nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
    }
    else
    {
        int volba = 0;
        VypisVedlejsiAkce();
        cin >> volba;
        if(volba ==1)
        {
            exit(0);
        }
        else if(volba == 2)
        {
            vypsatDoHTML(filmy, pocitadlo);
            cout << "Uspesne ulozeno" << endl;
            nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);

        }
        else if(volba ==3)
        {
            nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
        }
        else
        {
            cout << "Vase volba byla spatna" << endl;
            nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
        }

    }

}

/**
 * @brief Funkce pro vypsani vsech filmu ze zadaneho intervalu
 * @param filmy           pole filmu vytvorenych ze struktury Filmy
 * @param pocetFilmu      pocet filmu ve filmotece
 * @param herci           pole hercu vytvorenych ze struktury Herci
 * @param pocetHercu      pocet hercu v hercich
 */

void vypisPodleIntervalu(Filmy filmy[], int pocetFilmu, Herci herci[], int pocetHercu)
{
    cout << endl;
    vypsaneFilmy = (int*)malloc(sizeof(int));
    int prvni=0, druhy=0;
    cout << "Zadejte interval ve formatu: (rok mezera rok):";
    cin >> prvni;
    cin >> druhy;
    int pocitadlo = 0;
    if(prvni> druhy)
    {
        cout << "Zadali jste interval ve spatnem formatu" << endl;
        nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
    }
    else
    {
        cout << endl;
        for(int i = 0; i<pocetFilmu;i++)
        {
            if(prvni<=filmy[i].rok && druhy>= filmy[i].rok)
            {
                vypsaneFilmy[pocitadlo] = i;
                cout<< filmy[i].ID<< " ";
                cout<< filmy[i].jmeno<< " ";
                cout<< filmy[i].rok<< " ";
                cout<< filmy[i].zanr<< " ";
                cout<< filmy[i].puvod<< " ";
                cout<< filmy[i].delka<< " ";
                cout<< filmy[i].ID_Hercu<< endl;
                pocitadlo++;
            }
        }
        if(pocitadlo==0)
        {
            cout << "Ve vami zadanem obdobi se nenatocili zadne filmy" << endl;
            nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
        }
        else
        {
            int volba = 0;
            VypisVedlejsiAkce();
            cin >> volba;
            if(volba ==1)
            {
                exit(0);
            }
            else if(volba == 2)
            {
                vypsatDoHTML(filmy, pocitadlo);
                cout << "Uspesne ulozeno" << endl;
                nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
            }
            else if(volba ==3)
            {
                nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
            }
            else
            {
                cout << "Vase volba byla spatna" << endl;
                nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
            }
        }
    }
}

/**
 * @brief Funkce pro vypsani jednoho, uzivatelem vybraneho, filmu
 * @param filmy           pole filmu vytvorenych ze struktury Filmy
 * @param pocetFilmu      pocet filmu ve filmotece
 * @param herci           pole hercu vytvorenych ze struktury Herci
 * @param pocetHercu      pocet hercu v hercich
 */

void vypisFilm(Filmy filmy[], int pocetFilmu, Herci herci[],int pocetHercu)
{
    cout << endl;
    string nazev;
    unsigned int id;
    char volba;
    cout << "Zvolte zpusob zadavani filmu(I - ID; N - nazev): " << endl;
    cin  >> volba;
    vypsaneFilmy = (int*)malloc(sizeof(int));
    cout << endl;
    if(volba == 'I')
    {
        cout << "Zadejte ID filmu: " << endl;
        cin >> id;
        id--;
        if(id>14)
        {
            cout << "Zadali jste spatne id."<< endl;
            nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
        }
        else
        {
            vypsaneFilmy[0] = id;
            cout<< filmy[id].ID<< " ";
            cout<< filmy[id].jmeno<< " ";
            cout<< filmy[id].rok<< " ";
            cout<< filmy[id].zanr<< " ";
            cout<< filmy[id].puvod<< " ";
            cout<< filmy[id].delka<< " ";
            cout<< filmy[id].ID_Hercu<< endl;
            int volba = 0;
            VypisVedlejsiAkce();
            cin >> volba;
            if(volba ==1)
            {
                exit(0);
            }
            else if(volba == 2)
            {
                vypsatDoHTML(filmy,1);
                cout << "Uspesne ulozeno" << endl;
                nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
            }
            else if(volba ==3)
            {
                nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
            }
            else
            {
                cout << "Vase volba byla spatna" << endl;
                nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
            }
        }

    }
    else if(volba == 'N')
    {
        unsigned int pocitadlo = 0;
        cout << "Zadejte nazev filmu: " << endl;
        cin >> nazev;

        for(int i = 0; i < pocetFilmu;i++)
        {
            if(nazev == filmy[i].jmeno)
            {
                vypsaneFilmy[0] = i;
                cout<< filmy[i].ID<< " ";
                cout<< filmy[i].jmeno<< " ";
                cout<< filmy[i].rok<< " ";
                cout<< filmy[i].zanr<< " ";
                cout<< filmy[i].puvod<< " ";
                cout<< filmy[i].delka<< " ";
                cout<< filmy[i].ID_Hercu<< endl;
                pocitadlo++;
            }
        }
        if(pocitadlo == 0)
        {
            cout << "Neexistuje film s timto nazvem" << endl;
            nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
        }
        else
        {
            int volba = 0;
            VypisVedlejsiAkce();
            cin >> volba;
            if(volba == 1)
            {
                exit(0);
            }
            else if(volba == 2)
            {
                vypsatDoHTML(filmy, pocitadlo);
                cout << "Uspesne ulozeno" << endl;
                nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
            }
            else if(volba ==3)
            {
                nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
            }
            else
            {
                cout << "Vase volba byla spatna" << endl;
                nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
            }
        }
    }
    else
    {
        cout << "Vase volba byla zadana ve spatnem formatu." << endl;
        nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
    }
}

/**
 * @brief Funkce pro vypsani jednoho, uzivatelem zvoleneho, herce
 * @param filmy           pole filmu vytvorenych ze struktury Filmy
 * @param pocetFilmu      pocet filmu ve filmotece
 * @param herci           pole hercu vytvorenych ze struktury Herci
 * @param pocetHercu      pocet hercu v hercich
 */

void vypisHerce(Filmy filmy[], int pocetFilmu, Herci herci[], int pocetHercu)
{
    cout << endl;
    string nazev;
    int id;
    char volba;
    cout << "Zvolte zpusob vyberu herce(I - ID; P - prijmeni herce): " << endl;
    cin  >> volba;
    int pocitadlo = 0;
    vypsaneFilmy = (int*)malloc(sizeof(int));
    cout << endl;
    if(volba == 'I')
    {
        cout << "Zadejte ID herce: " << endl;
        cin >> id;
        cout << endl;
        if(id>14)
        {
            cout << "Zadali jste spatne id."<< endl;
        }
        else
        {
            id--;
            cout << herci[id].ID << " ";
            cout << herci[id].jmeno<< " ";
            cout << herci[id].prijmeni<< " ";
            cout << herci[id].datum_Narozeni<< " ";
            cout << herci[id].misto_Narozeni<< endl;
            cout << "Filmy ve kterych herec hral: "<< endl;
            for(int i = 0; i<pocetFilmu;i++)
            {
                int *poleID;
                poleID = (int*)malloc(sizeof(int));
                string herec = filmy[i].ID_Hercu;
                string sub = "";
                int k = 0;
                int l = 0;
                while(k<=herec.length())
                {

                    if(herec[k] != ' ')
                    {
                        sub+= herec[k];
                    }
                    else
                    {
                        poleID[l] = atoi(sub.c_str());
                        sub = "";
                        l++;
                    }
                    k++;
                    if(k == herec.length())
                    {
                        poleID[l] = atoi(sub.c_str());
                    }
                }

                for(int j = 0; j<=l;j++)
                {
                    if(poleID[j]==id+1)
                    {
                        vypsaneFilmy[pocitadlo] = i;
                        cout<< filmy[i].ID << " ";
                        cout<< filmy[i].jmeno << " ";
                        cout<< filmy[i].rok << " ";
                        cout<< filmy[i].zanr << " ";
                        cout<< filmy[i].puvod << " ";
                        cout<< filmy[i].delka << " ";
                        cout<< filmy[i].ID_Hercu << endl;
                        pocitadlo++;
                    }
                }
            }

        }
        int volba = 0;
        VypisVedlejsiAkce();
        cin >> volba;
        if(volba ==1)
        {
            exit(0);
        }
        else if(volba == 2)
        {
            string nazevSouboru = "";
            cout << "Zadejte nazev soboru(bez pripony)" << endl;
            cin >> nazevSouboru;
            ofstream out(("..\\vystupnidata\\"+ nazevSouboru+ ".html").c_str());
            out << "<html>"<<endl;
            out << "<head>"<<endl;
            out << "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">"<<endl;
            out << "<title>C++</title>"<<endl;
            out << "</head>"<<endl;
            out << "<body>"<<endl;
            out << "<table width=\"630\">"<<endl;
            out << "<tr><th width=\"10\">ID</th><th width=\"210\">Jmeno</th><th width=\"210\">Prijmeni</th><th width=\"100\">Datum Narozeni</th><th width=\"100\">Misto Narozeni</th></tr>"<<endl;
            out << "<tr><td>" << herci[id].ID  << "</td><td>"<< herci[id].jmeno << "</td><td>" << herci[id].prijmeni << "</td><td>"<< herci[id].datum_Narozeni << "</td><td>"<< herci[id].misto_Narozeni << "</td></tr>" << endl;
            out << "<p>Filmy ve kterych herec hral: </p>" << endl;
            out << endl;
            for(int i=0; i<pocitadlo; i++){
            out << "<tr>" + filmy[vypsaneFilmy[i]].jmeno + " " + "</tr>";
            }
            out << "</table>"<<endl;
            out <<"</body>"<< endl;
            out <<"</html>"<< endl;
            cout << "Uspesne ulozeno" << endl;
            nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
        }
        else if(volba == 3)
        {
            nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
        }
        else
        {
            cout << "Vase volba byla spatna" << endl;
            nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
        }

    }
    else if(volba == 'P')
    {
        unsigned int pocitadlo = 0;
        int index = -1;
        cout << "Zadejte prijmeni herce: " << endl;
        cin >> nazev;
        vypsaneFilmy = (int*)malloc(sizeof(int));
        cout << endl;
        for(int i = 0; i < pocetHercu;i++)
        {
            if(nazev == herci[i].prijmeni)
            {
                cout << herci[i].ID << " ";
                cout << herci[i].jmeno<< " ";
                cout << herci[i].prijmeni<< " ";
                cout << herci[i].datum_Narozeni<< " ";
                cout << herci[i].misto_Narozeni<< endl;
                index = herci[i].ID;
                break;
            }
        }

        cout << "Filmy ve kterych herec hral: " << endl;
        for(int i = 0; i<pocetFilmu;i++)
        {
            int *poleID;
            poleID = (int*)malloc(sizeof(int));
            string herec = filmy[i].ID_Hercu;
            string sub = "";
            int k = 0;
            int l = 0;
            while(k<=herec.length())
            {
                if(herec[k] != ' ')
                {
                    sub+= herec[k];
                }
                else
                {
                    poleID[l] = atoi(sub.c_str());
                    sub = "";
                    l++;
                }
                k++;
                if(k == herec.length())
                {
                    poleID[l] = atoi(sub.c_str());
                }
            }
            for(int j = 0; j<=l;j++)
            {
                if(poleID[j]==index)
                {
                    vypsaneFilmy[pocitadlo] = i;
                    cout<< filmy[i].ID<< " ";
                    cout<< filmy[i].jmeno<< " ";
                    cout<< filmy[i].rok<< " ";
                    cout<< filmy[i].zanr<< " ";
                    cout<< filmy[i].puvod<< " ";
                    cout<< filmy[i].delka<< " ";
                    cout<< filmy[i].ID_Hercu<< endl;
                    pocitadlo++;
                }
            }


        }
        int volba = 0;
        VypisVedlejsiAkce();
        cin >> volba;
        if(volba ==1)
        {
            exit(0);
        }
        else if(volba == 2)
        {
            string nazevSouboru = "";
            cout << "Zadejte nazev soboru(bez pripony)" << endl;
            cin >> nazevSouboru;
            ofstream out(("..\\vystupnidata\\"+ nazevSouboru+ ".html").c_str());
            out << "<html>"<<endl;
            out << "<head>"<<endl;
            out << "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">"<<endl;
            out << "<title>C++</title>"<<endl;
            out << "</head>"<<endl;
            out << "<body>"<<endl;
            out << "<table width=\"630\">"<<endl;
            out << "<tr><th width=\"10\">ID</th><th width=\"210\">Jmeno</th><th width=\"210\">Prijmeni</th><th width=\"100\">Datum Narozeni</th><th width=\"100\">Misto Narozeni</th></tr>"<<endl;
            out << "<tr><td>" << herci[id].ID  << "</td><td>"<< herci[id].jmeno << "</td><td>" << herci[id].prijmeni << "</td><td>"<< herci[id].datum_Narozeni << "</td><td>"<< herci[id].misto_Narozeni << "</td></tr>" << endl;
            out << "<p>Filmy ve kterych herec hral: </p>" << endl;
            out << endl;
            for(int i=0; i<pocitadlo; i++){
            out << "<tr>" + filmy[vypsaneFilmy[i]].jmeno + " " + "</tr>";
            }
            out << "</table>"<<endl;
            out <<"</body>"<< endl;
            out <<"</html>"<< endl;
            cout << "Uspesne ulozeno" << endl;
            nabizeneAkce(filmy,pocetFilmu, herci, pocetHercu);
        }
        else if(volba == 3)
        {
            nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
        }
        else
        {
            cout << "Vase volba byla spatna" << endl;
            nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
        }
    }

}

/**
 * @brief Funkce pro vyber akce
 * @param filmy           pole filmu vytvorenych ze struktury Filmy
 * @param pocetFilmu      pocet filmu ve filmotece
 * @param herci           pole hercu vytvorenych ze struktury Herci
 * @param pocetHercu      pocet hercu v hercich
 * @param cisloAkce       cislo, ktere zvolil uzivatel
 */

void vyberAkci(Filmy filmy[], int cisloAkce, int pocetFilmu, Herci herci[], int pocetHercu)
{
    switch(cisloAkce)
    {
        case 1: {
        vypisFilmy(filmy, pocetFilmu, herci, pocetHercu);
        break;
        }
        case 2: {
        vypisPodleZanru(filmy, pocetFilmu, herci, pocetHercu);
        break;
        }
        case 3: {
        vypisPodleIntervalu(filmy, pocetFilmu, herci, pocetHercu);
        break;
        }
        case 4: {
        vypisFilm(filmy, pocetFilmu, herci, pocetHercu);
        break;
        }
        case 5: {
        vypisHerce(filmy, pocetFilmu, herci, pocetHercu);
        break;
        }
    }
}

/**
 * @brief Funkce, ktera nabizi z jakych  moznosti si muze uzivatel vybrat
 * @param filmy           pole filmu vytvorenych ze struktury Filmy
 * @param pocetFilmu      pocet filmu ve filmotece
 * @param herci           pole hercu vytvorenych ze struktury Herci
 * @param pocetHercu      pocet hercu v hercich
 */

void nabizeneAkce(Filmy filmy[], int pocetFilmu, Herci herci[], int pocetHercu)
{
    cout << "Zadejte cislo vami pozadovane akce:" << endl;
    cout << "1. Vypise seznam filmu" << endl;
    cout << "2. Vypise seznam filmu podle vami zvoleneho zanru" << endl;
    cout << "3. Vypise seznam filmu natocenych v urcitych letech" << endl;
    cout << "4. Vypise informace o vami zvolenem filmu" << endl;
    cout << "5. Vypise informace o vami zvolenem herci" << endl;
    int cisloAkce = 0;
    cin >> cisloAkce;
    if(cisloAkce>0 && cisloAkce<6)
    {
      vyberAkci(filmy, cisloAkce, pocetFilmu, herci, pocetHercu);
    }
    else
    {
        cout << "Vyberte cislo 1 az 5" << endl;
        cout << endl;
        nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
    }
}

/** @fn int main()
 *  @brief Hlavni funkce pro implementaci spravneho pouziti programu. Funkce main take kontroluje vstupy a podporuje vystupy hlavnich slozek.
 */

int main()
{
    ifstream souborFilmu("..\\vstupnidata\\seznam_filmu.csv");
    ifstream souborHercu("..\\vstupnidata\\herci.csv");

    if (!(souborFilmu.is_open())){
        cout << "Chyba pri nacitani souboru" << endl;
        return 0;
    }
    if (!(souborHercu.is_open())){
        cout << "Chyba pri nacitani souboru" << endl;
        return 0;
    }

    int pocetFilmu = pocetRadku(souborFilmu);
    int pocetHercu = pocetRadku(souborHercu);

    Filmy filmy[pocetFilmu];
    Herci herci[pocetHercu];
    naplnStrukturuFilmu(souborFilmu, filmy);
    naplnStrukturuHercu(souborHercu, herci);
    nabizeneAkce(filmy, pocetFilmu, herci, pocetHercu);
    return 0;
}

